// some variables to save
var _avrTime = new Array();
var _avrVolume = new Array();
var _avrItem = new Array();

// Helper function
function _avrThisMovie(movieName) {
    if(navigator.appName.indexOf('Microsoft') != -1) {
        return window[movieName];
    } else {
        return document[movieName];
    }
}
// Callback function (called from the player)
function getUpdate(typ, pr1, pr2, pid) {
    if (pid == 'null')
        return;
    switch (typ) {
        case 'time':
            _avrTime[pid] = pr1;
            break;
        case 'volume':
            _avrVolume[pid] = pr1;
            break;
        case 'item':
            _avrItem[pid] = pr1;
            break;
    }
}

function _avrSendEvent(id, typ, prm) {
    _avrThisMovie(id).sendEvent(typ, prm);
}

// public API
//
function AvrLoadFile(id, obj) {
    _avrThisMovie(id).loadFile(obj);
};

function AvrAddItem(id, obj, idx) {
    _avrThisMovie(id).addItem(obj,idx);
}

function AvrRemoveItem(id, idx) {
    _avrThisMovie(id).removeItem(idx);
}

function AvrTogglePause(id) {
    _avrSendEvent(id, 'playpause');
}

function AvrPlayNext(id) {
    _avrSendEvent(id, 'next');
}

function AvrPlayPrev(id) {
    _avrSendEvent(id, 'prev');
}

function AvrScrub(id, val) {
    _avrSendEvent(id, 'scrub', _avrTime[id] + val);
}

function AvrVolume(id, val) {
    _avrSendEvent(id, 'volume', _avrVolume[id] + val);
}

function AvrGetLink(id, val) {
    _avrSendEvent(id, 'getlink', (val == null) ? 0 : val);
}

function AvrPlay(id, val) {
    _avrSendEvent(id, 'playitem', (val == null) ? 0 : val);
}

function AvrStop(id) {
    _avrSendEvent(id, 'stop');
}

function AvrGetItemData(id, idx) {
    var obj = _avrThisMovie(id).itemData(idx);
    var nodes = "";
    for (var i in obj) { 
        nodes += "<li>"+i+": "+obj[i]+"</li>"; 
    }
    document.getElementById("data").innerHTML = nodes;
}

function AvrFlashWarn(msg,rloc,alt) {
    document.write(
            '<div style="background-color:red;color:white;width:160px">'+
            '<strong>'+msg+'</strong><br/>'+
            '<a href="http://www.adobe.com/go/getflashplayer" '+
            'onclick="window.open(this.href);return false;" '+
            'onkeypress="window.open(this.href);return false;">'+
            '<img src="'+rloc+'160x41_Get_Flash_Player.jpg" alt="'+alt+'"></img>'+
            '</a></div>');
}
