<?php
////////////////////////////////////////////////////////////////////
// FILE:         help.php
//------------------------------------------------------------------
// NAME:         Element: Help
// DESCRIPTION:  Element to display a help button and optional image
// VERSION:      1.0.0
// CREATED:      April 2008
// MODIFIED:     April 2008
//------------------------------------------------------------------
// AUTHOR:       NoNumber! (Peter van Westen)
// E-MAIL:       peter@nonumber.nl
// WEBSITE:      http://www.nonumber.nl
//------------------------------------------------------------------
// COPYRIGHT:    (C) 2008-2010 - NoNumber! - All Rights Reserved
// LICENSE:      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
////////////////////////////////////////////////////////////////////

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

class JElementHelp extends JElement {
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Help';

	function fetchElement($name, $value, &$node, $control_name) {
		JHTML::_('behavior.modal', 'a.modal');
		
		if ( !$value ) $value = 'Show Help File';
		$label		= ( isset($node->_attributes['label']) )?$node->_attributes['label']:'';
		$title		= JText::_($value);
		if ( $label ) $title .= ' - '.JText::_($label);
		$file		= ( isset($node->_attributes['file']) )?$node->_attributes['file']:'helppage.php';
		$image		= ( isset($node->_attributes['image']) )?$node->_attributes['image']:'';
		if ( $image && strpos($image,'/') === false) $image = '../images/'.$image;
		
		$path_base	= str_replace(DS,'/',$_SERVER['DOCUMENT_ROOT']);
		$url_root	= str_replace($path_base,'',str_replace(DS,'/',dirname(__FILE__))).'/';
		$link		= $url_root.$file;

		$html			= '';
		if ( $image ) $html	.= '<div style="float:right;"><img src="'.$url_root.$image.'" title="'.JText::_($label).'" alt="'.JText::_($label).'"></div>';
		$html			.= '<div class="button2-left"><div class="blank"><a class="modal" title="'.$title.'"  href="'.$url_root.$file.'" rel="{handler: \'iframe\', size: {x: 650, y: 375}}">'.JText::_($value).'</a></div></div>'."\n";

		return $html;
	}
}
?>