<?php
////////////////////////////////////////////////////////////////////
// FILE:         title.php
//------------------------------------------------------------------
// NAME:         Element: Title
// DESCRIPTION:  Element to displays a titel (with subtitle)
// VERSION:      1.0.0
// CREATED:      April 2008
// MODIFIED:     April 2008
//------------------------------------------------------------------
// AUTHOR:       NoNumber! (Peter van Westen)
// E-MAIL:       peter@nonumber.nl
// WEBSITE:      http://www.nonumber.nl
//------------------------------------------------------------------
// COPYRIGHT:    (C) 2008-2010 - NoNumber! - All Rights Reserved
// LICENSE:      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
////////////////////////////////////////////////////////////////////

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

class JElementTitle extends JElement {
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Title';

	function fetchTooltip($label, $description, &$node, $control_name, $name) {
		return 0;
	}

	function fetchElement($name, $value, &$node, $control_name) {
		$title			= ( isset($node->_attributes['title']) )?$node->_attributes['title']:'';
		$label			= ( isset($node->_attributes['label']) )?$node->_attributes['label']:'';
		$description	= ( isset($node->_attributes['description']) )?$description = $node->_attributes['description']:'';

		$html = '';
		if ( $title ) $html .= '<h4 style="margin: 0px;">'.JText::_($title).'</h4>';
		if ( $label ) $html .= '<h4 style="margin: 0px;">'.JText::_($label).'</h4>';
		if ( $value ) $html .= '<h4 style="margin: 0px;">'.JText::_($value).'</h4>';
		if ( $description ) $html .= JText::_($description);	
		
		$html = ($html)?'<div class="panel"><div style="padding: 2px 5px;">'.$html.'</div></div>':'<hr />';

		return $html;
	}
}